"""
HB_ModellingCamera V1.1

Last Modified: Oct/11/2018
Works with CINEMA 4D R16.050 and up.

Copyright: Holger Biebrach, www.c4dstuff.com


Name-US: HB_ModellingCamera

Description-US: Sets Workplane to current selected and makes a Ortographic Camera [SHIFT: Make a Perspective Modelling Camera]

Usage:
Sets Workplane to current selected Polygons or Object and makes a Ortographic Camera which is alligned to the selection. With HB_DefaultCamera you will exit this mode again.

Video Tutorial:
https://youtu.be/eEcAttV56kE?t=31m20s

Name-DE: HB_ModellierungsKamera
Description-DE: Setzt die Arbeitsebene auf die selektierten Elemente und erstellt eine ortogonale Kamera. [SHIFT: Erstelle Perspektifische Modelling Kamera]


ChangeLog:

Jun/11/2015 V1.0
- Release Version

Oct/11/2018 V1.1
- New Highres Icon

"""

import c4d

def SetLocalPR(obj):
    global TURBO
    if TURBO:    
        obj.SetRelRot(c4d.Vector(0,-0.69813170079773,0))
        obj.SetRelPos(c4d.Vector(0,250,-300))
    else:
        obj.SetRelRot(c4d.Vector(0,-1.5707963267949,0))
        obj.SetRelPos(c4d.Vector(0,20,0))
    return obj

def main():
    doc.StartUndo()
    global TURBO
    
    c4dVersion= c4d.GetC4DVersion()
    
    
    TURBO=False
    bc=c4d.BaseContainer()
    if doc.SearchObject("HB_ModellingCamera_ROOT"):
        obj= doc.SearchObject("HB_ModellingCamera_ROOT")
        
        doc.AddUndo(c4d.UNDOTYPE_DELETE, obj)
        obj.Remove()
        c4d.EventAdd()
        
        return
    
    
    if c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD,c4d.BFM_INPUT_CHANNEL,bc):
        if bc[c4d.BFM_INPUT_QUALIFIER] ==1 :
            TURBO=True
   
    drawBD = doc.GetActiveBaseDraw()  
    if c4dVersion >= 16000:
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_BASEGRID]=False
    
    c4d.CallCommand(431000009) # Align Workplane to Selection
    Workplane=c4d.modules.snap.GetWorkplaneObject(doc)
    WorkplaneMatrix=c4d.modules.snap.GetWorkplaneMatrix(doc, drawBD)
    
    Camera_ROOT=c4d.BaseObject(c4d.Onull)
    Camera_ROOT.SetName("HB_ModellingCamera_ROOT")
    Camera_ROOT.SetMg(WorkplaneMatrix)
    doc.AddUndo(c4d.UNDOTYPE_NEW, Camera_ROOT)
    Camera_ROOT[c4d.ID_BASEOBJECT_VISIBILITY_EDITOR]=1
    doc.InsertObject(Camera_ROOT)
    
    WorkplaneCamera=c4d.BaseObject(c4d.Ocamera)
    WorkplaneCamera.SetName("ModellingCamera")
    doc.AddUndo(c4d.UNDOTYPE_NEW, WorkplaneCamera)
    WorkplaneCamera.InsertUnder(Camera_ROOT)
    SetLocalPR(WorkplaneCamera)
    
    doc.GetActiveBaseDraw()[c4d.BASEDRAW_DATA_CAMERA]=WorkplaneCamera
    WorkplaneCamera[c4d.CAMERAOBJECT_NEAR_CLIPPING_ENABLE]=False
    if not TURBO:
        WorkplaneCamera[c4d.CAMERA_PROJECTION]=1

    doc.EndUndo()
    c4d.EventAdd()

if __name__=='__main__':
    main()
